import numpy as np
from matplotlib import pyplot as plt


######################################################################################################################################################
#   Code for producing Figure 5 in the main text.
#   The following data is used in this figure:
#   -- theoryForceDist-0pN_const.txt, theoretical leading and trailing leg step (and stomp) distribution under 0 pN backward load
#   -- theoryForceDist-1pN_const.txt, theoretical leading and trailing leg step (and stomp) distribution under 1 pN backward load
#   -- theoryForceDist-1_9pN_const.txt, theoretical leading and trailing leg step (and stomp) distribution under 1.9 pN backward load
#   -- theoryForceDist-2_5pN_const.txt, theoretical leading and trailing leg step (and stomp) distribution under 2.5 pN backward load
#
######################################################################################################################################################



axisLabelSize = 20
lw = 2.25
msize = 7
legendTxt = 16
mkWidth = 2
handle = 1.25
tickLen=10
tickLabel=16

params = {'backend': 'ps'}

plt.rcParams.update(params)


fig, axs = plt.subplots(1,2, figsize=(18, 6), squeeze=True)


dist, probs0  = np.transpose(np.loadtxt('theory_force_step_distributions/theoryForceDist-0pN_const.txt'))
_, probs1 = np.transpose(np.loadtxt('theory_force_step_distributions/theoryForceDist-1pN_const.txt'))
_, probs19  = np.transpose(np.loadtxt('theory_force_step_distributions/theoryForceDist-1_9pN_const.txt'))
_, probs25  = np.transpose(np.loadtxt('theory_force_step_distributions/theoryForceDist-2_5pN_const.txt'))



dist = dist[::2]
probs0 = probs0[::2]
probs1 = probs1[::2]
probs19 = probs19[::2]
probs25 = probs25[::2]


axs[0].plot(dist, probs0, 'b', linewidth=lw)
axs[0].plot(dist, probs1, 'r--', linewidth=lw)
axs[0].plot(dist, probs19, 'c-.', linewidth=lw)
axs[0].plot(dist, probs25, 'k:', linewidth=lw+0.75)

axs[0].plot(dist, probs0, 'bo', linewidth=lw)
axs[0].plot(dist, probs1, 'ro', linewidth=lw)
axs[0].plot(dist, probs19, 'co', linewidth=lw)
axs[0].plot(dist, probs25, 'ko', linewidth=lw+0.75)

axs[0].tick_params('both',direction='in',length=tickLen,labelsize=tickLabel, width=2)
axs[0].set_xlabel('Step Size (nm)', size=axisLabelSize)
axs[0].set_ylabel('Probability', size=axisLabelSize)
axs[0].set_xlim([-115,115])
axs[0].set_ylim([-0.01,0.275])
axs[0].text(94, 0.255, 'Forward\nSteps', size=18, horizontalalignment='center', verticalalignment='top')
axs[0].text(22, 0.215, 'Stomps', size=18, horizontalalignment='center', verticalalignment='top')
axs[0].text(-80, 0.065, 'Backward\nSteps', size=18, horizontalalignment='center', verticalalignment='top')
axs[0].text(-0.11,1.,'A',transform=axs[0].transAxes, horizontalalignment='right', verticalalignment='center', size=axisLabelSize+4)

axs[0].locator_params(nbins=6)


leg = axs[0].legend(['0 pN', '1.0 pN', '1.9 pN', '2.5 pN'], frameon=False, fontsize=legendTxt, handlelength=handle, title='Force', loc=2,borderaxespad=0.75)
axs[0].get_legend().get_title().set_size(legendTxt+4)


for axis in ['top','bottom','left','right']:
  axs[0].spines[axis].set_linewidth(2)


dist = dist[30:]
probs0 = probs0[30:]/np.sum(probs0[30:])
probs1 = probs1[30:]/np.sum(probs1[30:])
probs19 = probs19[30:]/np.sum(probs19[30:])
probs25 = probs25[30:]/np.sum(probs25[30:])


# axs[1].plot(dist, probs0, 'b', linewidth=lw)
# # axs[1].plot(simDist, sim0, 'b--', linewidth=lw)
# axs[1].plot(dist, probs1, 'r', linewidth=lw)
# # axs[1].plot(simDist, sim1, 'r--', linewidth=lw)
# axs[1].plot(dist, probs19, 'c', linewidth=lw)
# # axs[1].plot(simDist, sim2, 'c--', linewidth=lw)
# axs[1].plot(dist, probs25, 'k', linewidth=lw)

axs[1].plot(dist, probs0, 'b', linewidth=lw)
axs[1].plot(dist, probs1, 'r--', linewidth=lw)
axs[1].plot(dist, probs19, 'c-.', linewidth=lw)

axs[1].plot(dist, probs0, 'bo', linewidth=lw)
axs[1].plot(dist, probs1, 'ro', linewidth=lw)
axs[1].plot(dist, probs19, 'co', linewidth=lw)


axs[1].tick_params('both',direction='in',length=tickLen,labelsize=tickLabel, width=2)
axs[1].set_xlabel('Step Size (nm)', size=axisLabelSize)
axs[1].set_ylabel('Probability', size=axisLabelSize)
axs[1].set_xlim([35,110])
axs[1].set_ylim([-0.01,0.365])
axs[1].text(53, 0.3, 'Normalized\nForward\nSteps ', size=18, horizontalalignment='center', verticalalignment='top')
axs[1].locator_params(nbins=5)
axs[1].text(-0.09,1.,'B',transform=axs[1].transAxes, horizontalalignment='right', verticalalignment='center', size=axisLabelSize+4)


#['0 pN (Theory)','0 pN (BD)','1 pN (Theory)','1 pN (BD)','2 pN (Theory)','2 pN (BD)']
# leg = axs[1].legend(['0 pN (Theory)','0 pN (BD)','1 pN (Theory)','1 pN (BD)','2 pN (Theory)','2 pN (BD)'], frameon=False, fontsize=legendTxt, handlelength=handle, title='Force', loc=1,borderaxespad=0)
# axs[1].get_legend().get_title().set_size(legendTxt+4)


for axis in ['top','bottom','left','right']:
  axs[1].spines[axis].set_linewidth(2)


plt.savefig("force_step_distributions.pdf",bbox_inches='tight')


plt.show()
